% GETMEANANDSTD Computes the mean and std for each measurement batch.
%
%	[M, S, POS, A] = GETMEANANDSTD(SAMPLES, LOCATIONS, SINGLEVALUESNAN, IDS).
%
%   See Also GETSTATBYPOINT.
%
%   Copyright  2018 Universitat Jaume I (UJI)

% Permission is hereby granted, free of charge, to any person obtaining a copy of
% this software and associated documentation files (the "Software"), to deal in
% the Software without restriction, including without limitation the rights to
% use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
% of the Software, and to permit persons to whom the Software is furnished to do
% so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all
% copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.

function [M, S, pos, A] = getMeanAndStd(set, allData, beaconNumber,singleValuesNan)

    if (~exist('singleValuesNan','var'))
        singleValuesNan = false;
    end
    if (~exist('ids','var'))
        ids = [];
    end
    
    selectedBeacon = getFilterForBeacon(allData.ids,beaconNumber);
    data = applyFilter(allData,selectedBeacon');

   [M, S, pos, A] = getStatByPoint(set, data, singleValuesNan, @(v)mean(v,'omitnan'), @(v)std(v,'omitnan'));
end